Imports System.Data.SqlClient
Imports System.Data
Imports System.Web.Security

Partial Class Log_in_form
    Inherits System.Web.UI.Page
    Protected Sub cmdLogin_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdLogin.Click

        ' This code will get executed when the "Sign in" button is clicked and the first thing that is
        ' done is to check if the username and password corresponds to a user in the "Users" table.
        ' We are sending the username and password to the "ValidateUser" function in the If-statement
        ' and will then return an answer from this function, se this function after this subroutine.

        If ValidateUser(LoginUserName.Text, LoginUserPass.Text) Then

            ' We declare three variables that will be used to create a cookie for the signed in user. A ticket
            ' with information, a string that should include the encrypted ticket and a HttpCookie.
            Dim ticket As FormsAuthenticationTicket
            Dim cookie As String
            Dim httpCookie As HttpCookie

            ' The FormsAuthenticationTicket is filled with data for version, name, issue date,
            ' expiration date, if the cookie are persistent or not, user data and cookie path.
            ticket = New FormsAuthenticationTicket(1, LoginUserName.Text, DateTime.Now(), _
            DateTime.Now.AddMinutes(100), chkPersistCookie.Checked, HiddenAdminValue.Value, "MyPage")

            ' The cookie is set to the encrypted ticket
            cookie = FormsAuthentication.Encrypt(ticket)

            ' The httpCookie gets a name and the value from the cookie.
            httpCookie = New HttpCookie(FormsAuthentication.FormsCookieName(), cookie)

            ' We set the expiration date for the httpCookie if the checkbox of chkPersistCookie are checked.
            ' if we dont set the expiration date for the HttpCookie then it will be deleted when the browser
            ' is shut down.
            If (chkPersistCookie.Checked = True) Then
                httpCookie.Expires = ticket.Expiration
            End If

            ' Set the path for the HttpCookie.
            httpCookie.Path = FormsAuthentication.FormsCookiePath()

            ' Add the HttpCookie.
            Response.Cookies.Add(httpCookie)

            ' The user is redirected to "Protected-page.aspx".
            Response.Redirect("Protected-page.aspx", True)

        Else
            lblMessage.Text = "* Incorrect password or e-mail"
        End If

    End Sub

    Private Function ValidateUser(ByVal userName As String, ByVal passWord As String) As Boolean

        ' This is a check that is done for the entered user name, i has to be between 1 and 80
        ' characters. If this check false this function will return a "False" statement and the
        ' code below will not be executed.

        If ((userName.Length = 0) Or (userName.Length > 80)) Then
            System.Diagnostics.Trace.WriteLine("[ValidateUser] Input validation of userName failed.")
            Return False
        End If

        ' This is a check that is done for the entered password, i has to be between 1 and 25
        ' characters. If this check false this function will return a "False" statement and the
        ' code below will not be executed.

        If ((passWord.Length = 0) Or (passWord.Length > 25)) Then
            System.Diagnostics.Trace.WriteLine("[ValidateUser] Input validation of passWord failed.")
            Return False
        End If

        ' We receive the userName and passWord as variables when this function is called and we 
        ' create the variable "lookupPassword" as a string to store the password that is selected from
        ' the database. The hidden field "HiddenAdminValue" that should store a bit value that indicate
        ' if the user is Admin or not have it's value set to Blank at the start. The passWord that is
        ' passed to this function is encrypted with SHA1 because the password that is stored in the
        ' table "Users" are encrypted with SHA1 and therefore have to do this encryption to compare 
        ' the entered password with the stored password in the database.

        Dim lookupPassword As String = Nothing
        HiddenAdminValue.Value = ""
        Dim passwordHash As String = FormsAuthentication.HashPasswordForStoringInConfigFile(passWord, "SHA1")

        ' This code is used to select the password and admin value from the "Users" table according to
        ' the supplied username in the "sign in form".

        Try
            Dim ConnString As String = ConfigurationManager.ConnectionStrings("ConnectionString").ToString()
            Dim SelectUser As String = "SELECT Password, Admin FROM Users WHERE UserName = @UserName"

            ' The Using block is used to call dispose (close) automatically even if there are an exception.
            Using cn As New SqlConnection(ConnString), _
                  cmd As New SqlCommand(SelectUser, cn)
                cmd.Parameters.Add("@UserName", SqlDbType.VarChar, 80).Value = LoginUserName.Text

                cn.Open()

                ' We use SqlDataReader and just want to select one single row. The Admin value are
                ' supplied to the hidden field "HiddenAdminValue" and the Password are supplied to the
                ' "lookupPassword" string.

                ' The Using block is used to call dispose (close) automatically even if there are an exception.
                Using reader As SqlDataReader = cmd.ExecuteReader(System.Data.CommandBehavior.SingleRow)
                    While reader.Read()
                        HiddenAdminValue.Value = reader("Admin").ToString()
                        lookupPassword = reader("Password").ToString()
                    End While
                End Using

            End Using
        Catch ex As Exception
            System.Diagnostics.Trace.WriteLine("[ValidateUser] Exception " & ex.Message)
        End Try

        ' If no password is found this function will return false.

        If (lookupPassword Is Nothing) Then
            ' You could write failed login attempts here to the event log for additional security.
            Return False
        End If

        ' Compare lookupPassword and passwordHash by using a case-sensitive comparison.
        Return (String.Compare(lookupPassword, passwordHash, False) = 0)

    End Function
End Class
